
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glut.h>

#include <AR/gsub.h>
#include <AR/video.h>
#include <AR/param.h>
#include <AR/ar.h>


// ǉwb_
#include "GLMetaseq.h"
#include "GLLight.h"

// Cu̐ݒ
#pragma comment(lib,"libARd.lib")
#pragma comment(lib,"libARvideod.lib")
#pragma comment(lib,"libARgsubd.lib")


// t@C̐ݒ
#define CAMERA_CONFIG_FILE	"Data/WDM_camera_flipV.xml"	// Jݒt@C
#define CAMERA_PARAM_FILE	"Data/camera_para.dat"		// Jp[^t@C
#define PATT_FILE			"Data/patt.hiro"			// p^[t@C
#define MQO_FILE			"Data/axis.mqo"				// MQOt@CiWj

// O[oϐ
double	g_patt_width  = 80.0;			// p^[̃TCY[mm]
int		g_th_detect	  = 100;			// }[JF臒l
int		g_frame_count = 0;				// t[
int		g_patt_id;						// p^[ID
double	g_patt_center[2] = {0.0, 0.0};	// p^[̒Sʒu
double	g_patt_trans[3][4];				// Jϊsi_ϊsj


MQO_OBJECT g_mqoModel;	// ^ZRt@Cǂݍ񂾃f

static void	Init(void);
static void	Cleanup(void);
static void	KeyEvent(unsigned char key, int x, int y);
static void	MainLoop(void);
static void	Draw(void);
static FILE *fp;


static void Init( void )
{
	ARParam	wparam;
	ARParam	cparam;		// Jp[^
	int width, height;	// 摜TCY

	// rfIfoCX̏
	if ( arVideoOpen(CAMERA_CONFIG_FILE) < 0 ) exit(0);

	// EBhẼTCY擾
	if ( arVideoInqSize(&width, &height) < 0 ) exit(0);

	// Jp[^̐ݒ iʃTCYɍ킹ăp[^ݒ肷j
	if( arParamLoad(CAMERA_PARAM_FILE, 1, &wparam) < 0 ) {
		printf("Camera parameter load error !!\n");
		exit(0);
	}
	arParamChangeSize( &wparam, width, height, &cparam );
	arInitCparam( &cparam );

	// Jp[^̕\
	printf("*** Camera Parameter ***\n");
	arParamDisp( &cparam );

	// p^[̃[h
	g_patt_id = arLoadPatt(PATT_FILE);
	if ( g_patt_id < 0 ) {
		printf("pattern load error !!\n");
		exit(0);
	}

	// OtBbNXEBhE̕\
	argInit( &cparam, 1.0, 0, 0, 0, 0 );

	// f̃[hargInit()̌ɂ
	g_mqoModel = mqoCreateObject(MQO_FILE,1.0);

}


// vOI
static void Cleanup(void)
{
    arVideoCapStop();
    arVideoClose();
    argCleanup();
}


// L[Cxg
static void KeyEvent( unsigned char key, int x, int y)
{
	// quit if the ESC key is pressed
	if( key == 0x1b ) {
		printf("*** %f (frame/sec)\n", (double)g_frame_count/arUtilTimer());
		Cleanup();
		exit(0);
	}
}


// C[v
static void MainLoop(void)
{
	ARUint8			*dataPtr;
	ARMarkerInfo	*marker_info;
	int				marker_num;
	int				j, k;

	// 摜̎擾
	dataPtr = (ARUint8 *)arVideoGetImage();
	if ( dataPtr == NULL ) {
		arUtilSleep(2);
		return;
	}

	// t[̃JEg
	if( g_frame_count == 0 ) arUtilTimerReset();
	g_frame_count++;

	// Lv`摜̕\
	argDrawMode2D();
	argDispImage( dataPtr, 0, 0 );

	// }[J̔F
	if( arDetectMarker(dataPtr, g_th_detect, &marker_info, &marker_num) < 0 ) {
		Cleanup();
		exit(0);
	}

	// ̃t[̃Lv`X^[g
	arVideoCapNext();

	// oꂽ}[J̐MxrCǂIDƑւׂD
	k = -1;
	for ( j=0; j<marker_num; j++ ) {
		if (marker_info[j].id == g_patt_id) {
			if ( k == -1 ) {
				k = j;
			} else if ( marker_info[j].cf > marker_info[k].cf ) {
				k = j;
			}
		}
	}
	if ( k == -1 ) {
		argSwapBuffers();
		return;
	}

	// }[JEJԂ̕ϊ߂
	arGetTransMat(&marker_info[k], g_patt_center, g_patt_width, g_patt_trans);

	//////////////////////
	// IWivf
	// ]Wo
	//////////////////////
	/*@ݗpdataJ@*/
	if((fp = fopen("Data/data.txt","w"))==NULL){
		exit(1);
	}
	fprintf(fp,"%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%f\n%d\n%f\n%f\n",g_patt_trans[0][0],g_patt_trans[0][1],g_patt_trans[0][2],g_patt_trans[0][3],g_patt_trans[1][0],g_patt_trans[1][1],g_patt_trans[1][2],g_patt_trans[1][3],g_patt_trans[2][0],g_patt_trans[2][1],g_patt_trans[2][2],g_patt_trans[2][3],marker_info[k].vertex[0][0],marker_info[k].vertex[0][1],marker_info[k].vertex[1][0],marker_info[k].vertex[1][1],marker_info[k].vertex[2][0],marker_info[k].vertex[2][1],marker_info[k].vertex[3][0],marker_info[k].vertex[3][1],marker_info[k].dir,marker_info[k].pos[0],marker_info[k].pos[1]);
	fclose(fp);

	//////////////////////
	// ܂
	//////////////////////

	Draw();
	argSwapBuffers();
}


// `Cxg
static void Draw(void)
{
	double    gl_para[16];
	GLfloat   mat_ambient[]     = {0.0, 0.0, 1.0, 1.0};
	GLfloat   mat_flash[]       = {0.0, 0.0, 1.0, 1.0};
	GLfloat   mat_flash_shiny[] = {50.0};
	GLfloat   light_position[]  = {100.0,-200.0,200.0,0.0};
	GLfloat   ambi[]            = {0.1, 0.1, 0.1, 0.1};
	GLfloat   lightZeroColor[]  = {0.9, 0.9, 0.9, 0.1};

	argDrawMode3D();
	argDraw3dCamera( 0, 0 );
	glClearDepth( 1.0 );
	glClear(GL_DEPTH_BUFFER_BIT);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);


	// Jsɂ鎋_̐ݒ
	argConvGlpara(g_patt_trans, gl_para);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd( gl_para );

	LightOn( 0, 1000, 0,	// ̈ʒu
			 1.0, 1.0, 1.0,	// gUˌW
			 0.1, 0.1, 0.1,	// ʔˌW
			 0.1, 0.1, 0.1,	// ˌW
			 10.0);	

	mqoCallObject(g_mqoModel);	// MQOf̃R[

	LightOff();

	glDisable( GL_LIGHTING );
	glDisable( GL_DEPTH_TEST );
}

// main֐
int main(int argc, char **argv)
{
	// OpenGL̏
	glutInit(&argc, argv);

	Init();

	arVideoCapStart();
	argMainLoop( NULL, KeyEvent, MainLoop );

	return (0);
}

